/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.manager;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.examples.feedcombiner.manager.FeedTaskFactory;
import org.glassfish.jersey.examples.feedcombiner.model.CombinedFeed;
import org.glassfish.jersey.examples.feedcombiner.store.DataStoreObserver;

public class FeedDataStoreManager
implements DataStoreObserver {
    private static final long START_DELAY = 0L;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    private final ScheduledExecutorService scheduler;
    private final FeedTaskFactory taskFactory;
    private final Map<String, ScheduledFuture<?>> scheduledTasks = new ConcurrentHashMap();

    public FeedDataStoreManager(FeedTaskFactory taskFactory) {
        this(taskFactory, Executors.newScheduledThreadPool(1));
    }

    public FeedDataStoreManager(FeedTaskFactory taskFactory, ScheduledExecutorService scheduler) {
        this.taskFactory = taskFactory;
        this.scheduler = scheduler;
    }

    public void save(Serializable entity) {
        this.createTask(entity);
    }

    public void saveAll(Collection<Serializable> entities) {
        entities.forEach(arg_0 -> this.createTask(arg_0));
    }

    private void createTask(Serializable serializableEntity) {
        if (serializableEntity instanceof CombinedFeed) {
            CombinedFeed feed = (CombinedFeed)serializableEntity;
            ScheduledFuture<?> scheduledTask = this.scheduler.scheduleAtFixedRate((Runnable)this.taskFactory.get(feed), 0L, feed.getRefreshPeriod(), DEFAULT_TIME_UNIT);
            this.scheduledTasks.put(feed.getId(), scheduledTask);
        }
    }

    public void remove(String key) {
        this.removeTask(key);
    }

    public void removeAll(Collection<String> keys) {
        keys.forEach(arg_0 -> this.removeTask(arg_0));
    }

    private void removeTask(String key) {
        ScheduledFuture scheduledTask = (ScheduledFuture)this.scheduledTasks.get(key);
        if (scheduledTask != null) {
            scheduledTask.cancel(true);
            this.scheduledTasks.remove(key);
        }
    }
}

