/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.manager;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedDownloader
implements Function<URL, List<SyndEntry>> {
    private static Logger LOG = LoggerFactory.getLogger((String)FeedDownloader.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SyndEntry> apply(URL url) {
        try (XmlReader xmlReader = new XmlReader(url);){
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)xmlReader);
            List list = feed.getEntries();
            return list;
        }
        catch (Exception e) {
            LOG.warn("An error during downloading and parsing a given feed: " + url, (Throwable)e);
            return Collections.emptyList();
        }
    }
}

