/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.resources;

import java.io.Serializable;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.examples.feedcombiner.model.CombinedFeed;
import org.glassfish.jersey.examples.feedcombiner.service.CrudService;
import org.glassfish.jersey.server.validation.ValidationError;

@Path(value="feeds")
public class CombinedFeedResource {
    @Context
    private UriInfo uriInfo;
    @Inject
    private CrudService<CombinedFeed> feedService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@Valid CombinedFeed insertedFeed) {
        CombinedFeed feed = (CombinedFeed)this.feedService.save((Serializable)insertedFeed);
        return Response.created((URI)this.getEntityLocation(feed.getId())).entity((Object)feed).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") String feedId) {
        Serializable deleted = this.feedService.delete(feedId);
        if (deleted != null) {
            return Response.noContent().build();
        }
        throw this.notFoundException(feedId);
    }

    @GET
    @Path(value="/{id}/entries")
    @Produces(value={"application/json", "application/atom+xml"})
    public Response getEntries(@PathParam(value="id") String feedId) {
        CombinedFeed combinedFeed = (CombinedFeed)this.feedService.get(feedId);
        if (combinedFeed != null) {
            return Response.ok((Object)new /* Unavailable Anonymous Inner Class!! */).build();
        }
        throw this.notFoundException(feedId);
    }

    private NotFoundException notFoundException(String feedId) {
        String message = "No Combined Feed was found with ID: " + feedId;
        Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ValidationError(message, null, null, feedId)).build();
        return new NotFoundException(message, response);
    }

    private URI getEntityLocation(String entityId) {
        URI absolutePath = this.uriInfo.getAbsolutePath();
        return UriBuilder.fromUri((URI)absolutePath).path("/" + entityId).build(new Object[0]);
    }
}

