/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.glassfish.jersey.examples.feedcombiner.store.DataStoreObserver;
import org.glassfish.jersey.examples.feedcombiner.store.InMemoryDataStore;
import org.glassfish.jersey.examples.feedcombiner.store.ObservableDataStore;
import org.glassfish.jersey.examples.feedcombiner.store.ReadWriteLockDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReadWriteLockDataStore
implements InMemoryDataStore,
ObservableDataStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)ReadWriteLockDataStore.class.getName());
    private static final Predicate<Object> DATASTORE_CAST_CHECKER = new DataStoreCastChecker(null);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readerLock = this.lock.readLock();
    private final Lock writerLock = this.lock.writeLock();
    private HashMap<String, Serializable> datastore = new HashMap();
    private Set<DataStoreObserver> observers = new CopyOnWriteArraySet();

    private static Optional<Object> deserialize(InputStream input) throws IOException {
        try {
            BufferedInputStream bis = new BufferedInputStream(input);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return Optional.of(ois.readObject());
        }
        catch (ClassNotFoundException ex) {
            LOG.error("An error occurred during deserialization an object.", (Throwable)ex);
            return Optional.empty();
        }
    }

    private static void serialize(Serializable object, OutputStream output) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(output);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        bos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> Serializable put(String key, T data) {
        Objects.requireNonNull(key, "The parameter 'key' must not be null");
        this.writerLock.lock();
        try {
            if (data == null) {
                this.observers.forEach(observer -> observer.remove(key));
                Serializable serializable = (Serializable)this.datastore.remove(key);
                return serializable;
            }
            T previousEntity = this.datastore.put(key, data);
            if (previousEntity == null) {
                this.observers.forEach(observer -> observer.save(data));
            }
            T t = previousEntity;
            return t;
        }
        finally {
            this.writerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> T get(String key, Class<T> type) {
        Objects.requireNonNull(key, "The parameter 'key' must not be null");
        Objects.requireNonNull(type, "The parameter 'type' must not be null");
        this.readerLock.lock();
        try {
            Serializable object = (Serializable)this.datastore.get(key);
            Serializable serializable = (Serializable)type.cast(object);
            return (T)serializable;
        }
        finally {
            this.readerLock.unlock();
        }
    }

    public void save(OutputStream out) throws IOException {
        this.readerLock.lock();
        try {
            ReadWriteLockDataStore.serialize((Serializable)this.datastore, (OutputStream)out);
        }
        finally {
            this.readerLock.unlock();
        }
    }

    public void load(InputStream in) throws IOException {
        Optional newDatastore = ReadWriteLockDataStore.deserialize((InputStream)in);
        newDatastore.filter(DATASTORE_CAST_CHECKER).map(HashMap.class::cast).ifPresent(loadedStore -> {
            this.writerLock.lock();
            try {
                this.observers.forEach(observer -> observer.removeAll(this.datastore.keySet()));
                this.datastore = loadedStore;
                this.observers.forEach(observer -> observer.saveAll(loadedStore.values()));
            }
            finally {
                this.writerLock.unlock();
            }
        });
    }

    public void addObserver(DataStoreObserver observer) {
        Objects.requireNonNull(observer, "It's not possible to add 'null' observer.");
        this.observers.add(observer);
    }

    public void deleteObserver(DataStoreObserver observer) {
        this.observers.remove(observer);
    }

    public Collection<Serializable> getAll() {
        this.readerLock.lock();
        try {
            Collection<Serializable> collection = this.datastore.values();
            return collection;
        }
        finally {
            this.readerLock.unlock();
        }
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

