/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.binder;

import java.io.InputStream;
import java.util.Properties;
import org.glassfish.jersey.examples.feedcombiner.binder.ApplicationBinder;
import org.glassfish.jersey.examples.feedcombiner.store.InMemoryDataStore;
import org.glassfish.jersey.examples.feedcombiner.store.ObservableDataStore;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApplicationBinder
extends AbstractBinder {
    private static final Logger LOG = LoggerFactory.getLogger((String)ApplicationBinder.class.getName());
    private final Properties properties;
    private final ObservableDataStore datastore;
    private final boolean activeScheduler;

    public ApplicationBinder(ObservableDataStore datastore, String propertiesFileName) {
        this(datastore, propertiesFileName, true);
    }

    public ApplicationBinder(ObservableDataStore datastore, String propertiesFileName, boolean activeScheduler) {
        this.datastore = datastore;
        this.properties = ApplicationBinder.getProperties((String)propertiesFileName);
        this.activeScheduler = activeScheduler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getProperties(String path) {
        try (InputStream inputStream = ApplicationBinder.class.getClassLoader().getResourceAsStream(path);){
            Properties properties2 = new Properties();
            properties2.load(inputStream);
            Properties properties = properties2;
            return properties;
        }
        catch (Exception e) {
            LOG.warn("Property file '" + path + "' not found in the classpath", (Throwable)e);
            return null;
        }
    }

    protected void configure() {
        this.install(new AbstractBinder[]{new PropertiesBinder(this.properties), new ResourcePartBinder((InMemoryDataStore)this.datastore)});
        if (this.activeScheduler) {
            this.install(new AbstractBinder[]{new SchedulerPartBinder(this.datastore, this.properties)});
        }
    }
}

