/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.resources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.glassfish.jersey.examples.feedcombiner.model.CombinedFeed;
import org.glassfish.jersey.examples.feedcombiner.model.FeedRequestBean;
import org.glassfish.jersey.examples.feedcombiner.service.CrudService;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.Viewable;

@Path(value="/")
@ErrorTemplate(name="/error.ftl")
public class CombinedFeedController {
    @Inject
    private CrudService<CombinedFeed> feedService;

    @POST
    @Template(name="/index.ftl")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Viewable create(@Valid @BeanParam FeedRequestBean request) {
        String[] urlArray = (String[])this.createUrls(request.getUrls()).stream().toArray(String[]::new);
        CombinedFeed feed = new CombinedFeed.CombinedFeedBuilder(null, urlArray).title(request.getTitle()).description(request.getDescription()).refreshPeriod(request.getRefreshPeriod()).build();
        this.feedService.save((Serializable)feed);
        return new Viewable("/index.ftl", (Object)this.getModel());
    }

    @POST
    @Template(name="/index.ftl")
    @Path(value="/delete/{feedId}")
    public Viewable delete(@PathParam(value="feedId") String feedId) {
        Serializable deleted = this.feedService.delete(feedId);
        if (deleted != null) {
            return new Viewable("/index.ftl", (Object)this.getModel());
        }
        throw new NotFoundException("No Combined Feed was found with ID: " + feedId);
    }

    @GET
    @Template(name="/index.ftl")
    public Viewable getAll() {
        return new Viewable("/index.ftl", (Object)this.getModel());
    }

    @GET
    @Template(name="/feed-entries.ftl")
    @Path(value="/{id}")
    public CombinedFeed get(@PathParam(value="id") String feedId) {
        CombinedFeed combinedFeed = (CombinedFeed)this.feedService.get(feedId);
        if (combinedFeed != null) {
            return combinedFeed;
        }
        throw new NotFoundException("No Combined Feed was found with ID: " + feedId);
    }

    private Map<String, Object> getModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("feeds", this.feedService.getAll());
        return model;
    }

    private List<String> createUrls(String urlsWithCommas) {
        StringTokenizer tokenizer = new StringTokenizer(urlsWithCommas, ",");
        ArrayList<String> urls = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            urls.add(tokenizer.nextToken());
        }
        return urls;
    }
}

