/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.provider;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.examples.feedcombiner.model.FeedEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/atom+xml"})
public class FeedEntriesAtomBodyWriter
implements MessageBodyWriter<List<FeedEntry>> {
    private static Logger LOG = LoggerFactory.getLogger((String)FeedEntriesAtomBodyWriter.class.getName());

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MediaType.APPLICATION_ATOM_XML_TYPE.isCompatible(mediaType) && Collection.class.isAssignableFrom(type) && ((ParameterizedType)genericType).getActualTypeArguments()[0].equals(FeedEntry.class);
    }

    public void writeTo(List<FeedEntry> entries, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        List syndEntries = entries.parallelStream().map(entry -> {
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(entry.getDescription());
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            syndEntry.setTitle(entry.getTitle());
            syndEntry.setLink(entry.getLink());
            syndEntry.setPublishedDate(entry.getPublishDate());
            syndEntry.setDescription((SyndContent)description);
            return syndEntry;
        }).collect(Collectors.toList());
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("atom_1.0");
        feed.setTitle("Combined Feed");
        feed.setDescription("Combined Feed created by a feed-combiner application");
        feed.setPublishedDate(new Date());
        feed.setEntries(syndEntries);
        this.writeSyndFeed(entityStream, (SyndFeed)feed);
    }

    public long getSize(List<FeedEntry> feeds, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    private void writeSyndFeed(OutputStream entityStream, SyndFeed feed) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(entityStream);
            SyndFeedOutput output = new SyndFeedOutput();
            output.output(feed, (Writer)writer);
            writer.close();
        }
        catch (FeedException | IOException e) {
            LOG.warn("An error occurred during writing a synd feed.", e);
        }
    }
}

