/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.flight.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.jersey.examples.flight.internal.SimEngine;
import org.glassfish.jersey.examples.flight.model.Location;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.ChunkedOutput;

public final class SimEngine {
    public static int X_BOUND = 800;
    public static int Y_BOUND = 350;
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final SseBroadcaster broadcaster = new SseBroadcaster();
    private static final AtomicBoolean started = new AtomicBoolean(false);

    public static boolean register(EventOutput output) {
        return broadcaster.add((ChunkedOutput)output);
    }

    public static boolean start() {
        if (!started.compareAndSet(false, true)) {
            return false;
        }
        executor.submit((Runnable)new SimRunner(null));
        return true;
    }

    public static boolean stop() {
        return started.compareAndSet(true, false);
    }

    public static Location bound(Location location) {
        int x = location.getX();
        int y = location.getY();
        if (x >= X_BOUND) {
            x %= X_BOUND;
        } else if (x < 0) {
            x = X_BOUND + x % X_BOUND;
        }
        if (y >= Y_BOUND) {
            y %= Y_BOUND;
        } else if (y < 0) {
            y = Y_BOUND + y % Y_BOUND;
        }
        return x != location.getX() || y != location.getY() ? new Location(x, y) : location;
    }

    static /* synthetic */ AtomicBoolean access$100() {
        return started;
    }

    static /* synthetic */ SseBroadcaster access$200() {
        return broadcaster;
    }

    static /* synthetic */ ScheduledExecutorService access$300() {
        return executor;
    }
}

