/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.flight.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.jersey.examples.flight.model.Aircraft;
import org.glassfish.jersey.examples.flight.model.AircraftType;
import org.glassfish.jersey.examples.flight.model.Flight;
import org.glassfish.jersey.examples.flight.model.Location;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataStore {
    public static final int CONCURRENCY_LEVEL = DataStore.ceilingNextPowerOfTwo((int)Runtime.getRuntime().availableProcessors());
    private static final ConcurrentMap<String, Flight> flights = new ConcurrentHashMap(16, 0.75f, CONCURRENCY_LEVEL);
    private static final Comparator<Flight> FLIGHT_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    private static final ConcurrentMap<Integer, Aircraft> aircrafts = new ConcurrentHashMap(16, 0.75f, CONCURRENCY_LEVEL);
    private static final AtomicInteger nextAircraftId = new AtomicInteger(1);
    private static final Comparator<Aircraft> AIRCRAFT_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    private static final Random rnd = new Random();
    public static final int MAX_GEN_AIRCRAFTS = 20;
    public static final int MAX_GEN_FLIGHTS = 10;
    private static final Set<AircraftType> aircraftTypes = DataStore.initAircraftTypes();

    private static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static List<Flight> selectAllFlights() {
        ArrayList<Flight> result = new ArrayList<Flight>(flights.values());
        Collections.sort(result, FLIGHT_COMPARATOR);
        return result;
    }

    public static List<Flight> selectOpenFlights() {
        ArrayList<Flight> result = new ArrayList<Flight>(flights.values());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Flight flight = (Flight)it.next();
            if (flight.isOpen()) continue;
            it.remove();
        }
        Collections.sort(result, FLIGHT_COMPARATOR);
        return result;
    }

    public static Flight selectFlight(String id) {
        return id == null ? null : (Flight)flights.get(id);
    }

    public static Flight selectFlightByAircraft(Integer id) {
        if (id == null) {
            return null;
        }
        Aircraft aircraft = DataStore.selectAircraft((Integer)id);
        if (aircraft == null || aircraft.isAvailable()) {
            return null;
        }
        for (Flight flight : flights.values()) {
            if (!flight.getAircraft().getId().equals(id)) continue;
            return flight;
        }
        return null;
    }

    public static boolean addFlight(Flight flight) {
        if (flight.getId() != null) {
            return flights.putIfAbsent(flight.getId(), flight) == null;
        }
        do {
            flight.setId(String.format("FL-%04d", rnd.nextInt(10000)));
        } while (flights.putIfAbsent(flight.getId(), flight) != null);
        return true;
    }

    public static Flight removeFlight(String id) {
        return id == null ? null : (Flight)flights.remove(id);
    }

    public static List<Aircraft> selectAllAircrafts() {
        ArrayList<Aircraft> result = new ArrayList<Aircraft>(aircrafts.values());
        Collections.sort(result, AIRCRAFT_COMPARATOR);
        return result;
    }

    public static List<Aircraft> selectAvailableAircrafts() {
        ArrayList<Aircraft> result = new ArrayList<Aircraft>(aircrafts.values());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Aircraft a = (Aircraft)it.next();
            if (a.isAvailable()) continue;
            it.remove();
        }
        Collections.sort(result, AIRCRAFT_COMPARATOR);
        return result;
    }

    public static Aircraft selectAircraft(Integer id) {
        return id == null ? null : (Aircraft)aircrafts.get(id);
    }

    public static boolean addAircraft(Aircraft aircraft) {
        boolean result;
        int id = nextAircraftId.getAndIncrement();
        boolean bl = result = aircrafts.putIfAbsent(id, aircraft) == null;
        if (result) {
            aircraft.setId(Integer.valueOf(id));
        }
        return result;
    }

    public static Aircraft removeAircraft(Integer id) {
        return id == null ? null : (Aircraft)aircrafts.remove(id);
    }

    private static Flight generateFlight() {
        Flight flight = new Flight();
        flight.setId(String.format("FL-%04d", rnd.nextInt(10000)));
        return flight;
    }

    private static Aircraft generateAircraft() {
        Aircraft aircraft = new Aircraft();
        Iterator iterator = aircraftTypes.iterator();
        int i = rnd.nextInt(aircraftTypes.size());
        AircraftType type = null;
        while (iterator.hasNext()) {
            type = (AircraftType)iterator.next();
            if (--i >= 0) continue;
        }
        aircraft.setType(type);
        aircraft.setLocation(DataStore.generateLocation((int)800, (int)350));
        return aircraft;
    }

    public static Location generateLocation(int xBound, int yBound) {
        return new Location(rnd.nextInt(xBound), rnd.nextInt(yBound));
    }

    public static void generateData() {
        flights.clear();
        aircrafts.clear();
        LinkedList<Aircraft> planes = new LinkedList<Aircraft>();
        while (planes.size() < 20) {
            Aircraft a = DataStore.generateAircraft();
            if (!DataStore.addAircraft((Aircraft)a)) continue;
            planes.add(a);
        }
        int count = 0;
        while (count < 10) {
            Flight flight = DataStore.generateFlight();
            if (!DataStore.addFlight((Flight)flight)) continue;
            ++count;
            Aircraft aircraft = (Aircraft)planes.remove(rnd.nextInt(planes.size()));
            aircraft.marAssigned();
            flight.setAircraft(aircraft);
        }
    }

    private static Set<AircraftType> initAircraftTypes() {
        LinkedHashSet<AircraftType> ats = new LinkedHashSet<AircraftType>();
        ats.add(new AircraftType("Airbus", "A318-100", 107));
        ats.add(new AircraftType("Airbus", "A319-100", 124));
        ats.add(new AircraftType("Airbus", "A320-200", 150));
        ats.add(new AircraftType("Airbus", "A321-200", 185));
        ats.add(new AircraftType("Airbus", "A330-200", 253));
        ats.add(new AircraftType("Airbus", "A330-300", 295));
        ats.add(new AircraftType("Airbus", "A330-500", 222));
        ats.add(new AircraftType("Airbus", "A330-500", 222));
        ats.add(new AircraftType("Airbus", "A340-200", 240));
        ats.add(new AircraftType("Airbus", "A340-300", 295));
        ats.add(new AircraftType("Airbus", "A340-500", 313));
        ats.add(new AircraftType("Airbus", "A340-600", 380));
        ats.add(new AircraftType("Airbus", "A350-800", 270));
        ats.add(new AircraftType("Airbus", "A350-900", 314));
        ats.add(new AircraftType("Airbus", "A350-1000", 350));
        ats.add(new AircraftType("Airbus", "A380-800", 525));
        ats.add(new AircraftType("Boeing", "737-200", 97));
        ats.add(new AircraftType("Boeing", "737-500", 146));
        ats.add(new AircraftType("Boeing", "737-900", 177));
        ats.add(new AircraftType("Boeing", "767-200", 181));
        ats.add(new AircraftType("Boeing", "767-300", 218));
        ats.add(new AircraftType("Boeing", "767-400", 245));
        ats.add(new AircraftType("Boeing", "777-200", 314));
        ats.add(new AircraftType("Boeing", "777-300", 386));
        ats.add(new AircraftType("Boeing", "787-8", 242));
        ats.add(new AircraftType("Boeing", "787-9", 280));
        ats.add(new AircraftType("Boeing", "787-10", 323));
        return Collections.unmodifiableSet(ats);
    }
}

