/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.flight.resources;

import java.util.Collection;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.glassfish.jersey.examples.flight.filtering.Detail;
import org.glassfish.jersey.examples.flight.internal.DataStore;
import org.glassfish.jersey.examples.flight.internal.SimEngine;
import org.glassfish.jersey.examples.flight.model.Aircraft;
import org.glassfish.jersey.examples.flight.model.AircraftType;
import org.glassfish.jersey.examples.flight.model.Flight;
import org.glassfish.jersey.examples.flight.model.Location;
import org.glassfish.jersey.examples.flight.validation.ValidAircraftId;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Template;

@Path(value="aircrafts")
@Produces(value={"application/xml", "application/json"})
public class AircraftsResource {
    @GET
    public Collection<Aircraft> list() {
        return DataStore.selectAllAircrafts();
    }

    @GET
    @Produces(value={"text/html"})
    @Template(name="/aircraft/list")
    public Collection<Aircraft> listAsHtml() {
        return this.list();
    }

    @GET
    @Produces(value={"text/plain;qs=0.5"})
    public String listAsString() {
        StringBuilder sb = new StringBuilder();
        for (Aircraft aircraft : this.list()) {
            sb.append(aircraft).append('\n');
        }
        return sb.toString();
    }

    @GET
    @Path(value="{id}")
    @Detail
    public Aircraft get(@ValidAircraftId @PathParam(value="id") Integer aircraftId) {
        return DataStore.selectAircraft((Integer)aircraftId);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"text/html"})
    @Template(name="/aircraft/detail")
    @ErrorTemplate(name="/errors/404")
    public Aircraft getAsHtml(@ValidAircraftId @PathParam(value="id") Integer id) {
        return this.get(id);
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"admin"})
    public String delete(@ValidAircraftId @PathParam(value="id") Integer id) {
        Flight flight = DataStore.selectFlightByAircraft((Integer)id);
        if (flight != null) {
            throw new BadRequestException("Aircraft assigned to a flight.");
        }
        Aircraft aircraft = DataStore.removeAircraft((Integer)id);
        return String.format("%03d", aircraft.getId());
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"admin"})
    @Detail
    public Aircraft create(@FormParam(value="manufacturer") String manufacturer, @FormParam(value="type") String type, @FormParam(value="capacity") Integer capacity, @DefaultValue(value="0") @FormParam(value="x-pos") Integer x, @DefaultValue(value="0") @FormParam(value="y-pos") Integer y) {
        if (manufacturer == null || type == null || capacity == null) {
            throw new BadRequestException("Incomplete data.");
        }
        Aircraft aircraft = new Aircraft();
        aircraft.setType(new AircraftType(manufacturer, type, capacity.intValue()));
        aircraft.setLocation(SimEngine.bound((Location)new Location(x.intValue(), y.intValue())));
        if (!DataStore.addAircraft((Aircraft)aircraft)) {
            throw new InternalServerErrorException("Unable to add new aircraft.");
        }
        return aircraft;
    }

    @GET
    @Path(value="available")
    public Collection<Aircraft> listAvailable() {
        return DataStore.selectAvailableAircrafts();
    }

    @GET
    @Path(value="available")
    @Produces(value={"text/plain;qs=0.5"})
    public String listAvailableAsString() {
        StringBuilder sb = new StringBuilder();
        for (Aircraft aircraft : this.listAvailable()) {
            sb.append(aircraft).append('\n');
        }
        return sb.toString();
    }
}

