/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.flight.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.jersey.examples.flight.model.Aircraft;
import org.glassfish.jersey.examples.flight.model.Flight;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Flight {
    private String id;
    private Status status = Status.OPEN;
    private int reservationsCount;
    private Aircraft aircraft;

    public Flight() {
    }

    public Flight(String id, Aircraft aircraft) {
        this.id = id;
        this.aircraft = aircraft;
    }

    public synchronized String getId() {
        return this.id;
    }

    public synchronized void setId(String id) {
        this.id = id;
    }

    public synchronized Aircraft getAircraft() {
        return this.aircraft;
    }

    public synchronized void setAircraft(Aircraft aircraft) {
        this.aircraft = aircraft;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized boolean isOpen() {
        return this.status == Status.OPEN;
    }

    public synchronized void setStatus(Status status) {
        this.status = status;
    }

    public synchronized void closeReservations() {
        this.status = Status.CLOSED;
    }

    public synchronized int getReservationsCount() {
        return this.reservationsCount;
    }

    public synchronized void setReservationsCount(int reservationsCount) {
        this.reservationsCount = reservationsCount;
    }

    public synchronized int nextReservationNumber() {
        if (this.reservationsCount < this.aircraft.getCapacity()) {
            return ++this.reservationsCount;
        }
        return -1;
    }

    public synchronized int getAvailableSeats() {
        return this.aircraft.getCapacity() - this.reservationsCount;
    }

    public synchronized String toString() {
        return String.format("%s (%s) {%s, seats: %3d / %3d}", this.id, this.status, this.aircraft, this.getAvailableSeats(), this.aircraft.getCapacity());
    }
}

