/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.flight.resources;

import java.util.Collection;
import java.util.HashMap;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.glassfish.jersey.examples.flight.filtering.Detail;
import org.glassfish.jersey.examples.flight.internal.DataStore;
import org.glassfish.jersey.examples.flight.model.Aircraft;
import org.glassfish.jersey.examples.flight.model.Flight;
import org.glassfish.jersey.examples.flight.validation.ValidAircraftId;
import org.glassfish.jersey.examples.flight.validation.ValidFlightId;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.Viewable;

@Path(value="flights")
@Produces(value={"application/xml", "application/json"})
public class FlightsResource {
    @GET
    public Collection<Flight> list() {
        return DataStore.selectAllFlights();
    }

    @GET
    @Produces(value={"text/html"})
    @Template(name="/flight/list")
    public Collection<Flight> listAsHtml() {
        return this.list();
    }

    @GET
    @Produces(value={"text/csv"})
    public Viewable listAsCsv() {
        return new Viewable("/flight/list-csv", (Object)this.list());
    }

    @GET
    @Produces(value={"application/x-yaml"})
    @Template(name="/flight/list-yaml")
    public Collection<Flight> listAsYaml() {
        return this.list();
    }

    @GET
    @Produces(value={"text/plain;qs=0.5"})
    public String listAsString() {
        StringBuilder sb = new StringBuilder();
        for (Flight flight : this.list()) {
            sb.append(flight).append('\n');
        }
        return sb.toString();
    }

    @GET
    @Path(value="{id}")
    @Detail
    public Flight get(@ValidFlightId @PathParam(value="id") String flightId) {
        return DataStore.selectFlight((String)flightId);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"text/html"})
    @Template(name="/flight/detail")
    @ErrorTemplate(name="/errors/404")
    public Flight getAsHtml(@ValidFlightId @PathParam(value="id") String flightId) {
        return this.get(flightId);
    }

    @POST
    @Path(value="{id}/new-booking")
    @Produces(value={"text/plain"})
    public String book(@ValidFlightId @PathParam(value="id") String flightId) {
        Flight flight = DataStore.selectFlight((String)flightId);
        if (!flight.isOpen()) {
            throw new BadRequestException("Flight closed.");
        }
        String ridString = "FAILED";
        int nextRid = flight.nextReservationNumber();
        if (nextRid > 0) {
            ridString = String.format("%s-%03d", flight.getId(), nextRid);
        }
        return ridString;
    }

    @POST
    @Path(value="{id}/new-booking")
    @Produces(value={"text/html"})
    public Viewable bookAsHtml(@PathParam(value="id") String flightId) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("flightId", flightId);
        model.put("reservationId", this.book(flightId));
        return new Viewable("/flight/reservation", model);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"admin"})
    @Detail
    public Flight create(@ValidAircraftId @FormParam(value="aircraftId") Integer aircraftId) {
        Aircraft aircraft = DataStore.selectAircraft((Integer)aircraftId);
        if (!aircraft.marAssigned()) {
            throw new BadRequestException("Aircraft already assigned.");
        }
        Flight flight = new Flight(null, aircraft);
        if (!DataStore.addFlight((Flight)flight)) {
            aircraft.marAvailable();
            throw new BadRequestException("Flight already exists.");
        }
        return flight;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"admin"})
    public String delete(@ValidFlightId @PathParam(value="id") String flightId) {
        Flight flight = DataStore.removeFlight((String)flightId);
        flight.getAircraft().marAvailable();
        return flight.getId();
    }

    @POST
    @Path(value="{id}/status")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"admin"})
    public String updateStatus(@ValidFlightId @PathParam(value="id") String flightId, @FormParam(value="status") String newStatus) {
        Flight.Status status;
        try {
            status = Flight.Status.valueOf((String)newStatus);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Unknown status.");
        }
        Flight flight = DataStore.selectFlight((String)flightId);
        flight.setStatus(status);
        return status.name();
    }

    @GET
    @Path(value="open")
    public Collection<Flight> listOpen() {
        return DataStore.selectOpenFlights();
    }

    @GET
    @Produces(value={"text/plain;qs=0.5"})
    @Path(value="open")
    public String listOpenAsString() {
        StringBuilder sb = new StringBuilder();
        for (Flight flight : this.listOpen()) {
            sb.append(flight).append('\n');
        }
        return sb.toString();
    }
}

