/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.flight.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.glassfish.jersey.examples.flight.filtering.Detail;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class AircraftType {
    private String manufacturer;
    private String model;
    @Detail
    private int capacity;

    public AircraftType() {
    }

    public AircraftType(String manufacturer, String model, int capacity) {
        this.manufacturer = manufacturer;
        this.model = model;
        this.capacity = capacity;
    }

    public synchronized String getManufacturer() {
        return this.manufacturer;
    }

    public synchronized void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public synchronized String getModel() {
        return this.model;
    }

    public synchronized void setModel(String model) {
        this.model = model;
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AircraftType at = (AircraftType)o;
        if (this.capacity != at.capacity) {
            return false;
        }
        if (this.manufacturer != null ? !this.manufacturer.equals(at.manufacturer) : at.manufacturer != null) {
            return false;
        }
        return !(this.model == null ? at.model != null : !this.model.equals(at.model));
    }

    public synchronized int hashCode() {
        int result = this.manufacturer != null ? this.manufacturer.hashCode() : 0;
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        result = 31 * result + this.capacity;
        return result;
    }

    public synchronized String toString() {
        return String.format("%6s %-9s [%3d]", this.manufacturer, this.model, this.capacity);
    }
}

