/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.flight.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.jersey.examples.flight.filtering.Detail;
import org.glassfish.jersey.examples.flight.model.Aircraft;
import org.glassfish.jersey.examples.flight.model.AircraftType;
import org.glassfish.jersey.examples.flight.model.Location;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Aircraft {
    private Integer id;
    private Status status = Status.AVAILABLE;
    private AircraftType type;
    @Detail
    private Location location;

    public synchronized Integer getId() {
        return this.id;
    }

    public synchronized void setId(Integer id) {
        this.id = id;
    }

    public synchronized AircraftType getType() {
        return this.type;
    }

    public synchronized void setType(AircraftType type) {
        this.type = type;
    }

    public synchronized int getCapacity() {
        return this.type.getCapacity();
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized void setStatus(Status status) {
        this.status = status;
    }

    public synchronized boolean isAvailable() {
        return this.status == Status.AVAILABLE;
    }

    public synchronized void marAvailable() {
        this.status = Status.AVAILABLE;
    }

    public synchronized boolean marAssigned() {
        if (this.status == Status.AVAILABLE) {
            this.status = Status.ASSIGNED;
            return true;
        }
        return false;
    }

    public synchronized Location getLocation() {
        return this.location;
    }

    public synchronized void setLocation(Location location) {
        this.location = location;
    }

    public synchronized String toString() {
        return String.format("A[%03d] { %s, %9s, located at %s}", this.id, this.type, this.status, this.location);
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Aircraft aircraft = (Aircraft)o;
        if (this.id != null ? !this.id.equals(aircraft.id) : aircraft.id != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals((Object)aircraft.location) : aircraft.location != null) {
            return false;
        }
        if (this.status != aircraft.status) {
            return false;
        }
        return !(this.type != null ? !this.type.equals((Object)aircraft.type) : aircraft.type != null);
    }

    public synchronized int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + this.status.hashCode();
        return result;
    }
}

