/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.examples.helloworld.Application;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.test.util.server.ContainerRequestBuilder;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Warmup(iterations=8, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=8, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1)
@State(value=Scope.Benchmark)
public class HelloWorldBenchmark {
    @Param(value={"helloworld", "helloworld/locator"})
    private String path;
    @Param(value={"GET", "POST", "PUT"})
    private String method;
    private volatile ApplicationHandler handler;
    private volatile ContainerRequest request;

    @Setup
    public void start() throws Exception {
        this.handler = new ApplicationHandler((javax.ws.rs.core.Application)new Application());
    }

    @Setup(value=Level.Iteration)
    public void request() {
        this.request = ContainerRequestBuilder.from((String)this.path, (String)this.method, (Configuration)this.handler.getConfiguration()).entity((Object)("GET".equals(this.method) ? null : "Hello World!"), this.handler).build();
    }

    @TearDown
    public void shutdown() {
    }

    @Benchmark
    public Future<ContainerResponse> measure() throws Exception {
        return this.handler.apply(this.request);
    }

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(HelloWorldBenchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }
}

