/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.GrizzlyHttpServerFactory;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.Application;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ROOT_PATH = "helloworld";
    public static volatile boolean getMethodCalled = false;
    public static volatile boolean headMethodCalled = false;

    public static void main(String[] args) {
        try {
            System.out.println("\"Hello World\" Jersey Example App");
            Application app = App.create();
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (Application)app);
            System.out.println(String.format("Application started.%nTry out %s%s%nHit enter to stop it...", BASE_URI, ROOT_PATH));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Application create() {
        Application.Builder appBuilder = Application.builder();
        appBuilder.bind(ROOT_PATH).method(new String[]{"GET"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                getMethodCalled = true;
                return Responses.from((int)200, (Request)data).entity((Object)"Hello World!").build();
            }
        }).method(new String[]{"HEAD", "OPTIONS"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                headMethodCalled = true;
                return Responses.from((int)204, (Request)data).build();
            }
        });
        return appBuilder.build();
    }
}

