/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ROOT_PATH = "helloworld";
    public static volatile boolean getMethodCalled = false;
    public static volatile boolean headMethodCalled = false;

    public static void main(String[] args) {
        try {
            System.out.println("\"Hello World\" Jersey Example App");
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)App.create());
            System.out.println(String.format("Application started.%nTry out %s%s%nHit enter to stop it...", BASE_URI, ROOT_PATH));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig create() {
        Resource.Builder resourceBuilder = Resource.builder((String)ROOT_PATH);
        resourceBuilder.addMethod("GET").handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext data) {
                getMethodCalled = true;
                return Response.ok((Object)"Hello World!").build();
            }
        });
        Inflector<ContainerRequestContext, Response> noContentResponder = new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext data) {
                headMethodCalled = true;
                return Response.noContent().build();
            }
        };
        resourceBuilder.addMethod("HEAD").handledBy((Inflector)noContentResponder);
        resourceBuilder.addMethod("OPTIONS").handledBy((Inflector)noContentResponder);
        return new ResourceConfig().addResources(new Resource[]{resourceBuilder.build()});
    }
}

