/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld.jaxrs;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.jersey.examples.helloworld.jaxrs.JaxRsApplication;

public class App {
    static HttpServer startServer() throws IOException {
        HttpServer server = HttpServer.create(new InetSocketAddress(App.getBaseURI().getPort()), 0);
        HttpHandler handler = (HttpHandler)RuntimeDelegate.getInstance().createEndpoint((Application)new JaxRsApplication(), HttpHandler.class);
        server.createContext(App.getBaseURI().getPath(), handler);
        server.start();
        return server;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("\"Hello World\" Jersey Example Application");
        HttpServer server = App.startServer();
        System.out.println("Application started.\nTry accessing " + App.getBaseURI() + "helloworld in the browser.\n" + "Hit enter to stop the application...");
        System.in.read();
        server.stop(0);
    }

    private static int getPort(int defaultPort) {
        String port = System.getProperty("jersey.test.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPort;
    }

    public static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(App.getPort(8080)).build(new Object[0]);
    }
}

