/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.hello.spring.annotations;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import org.glassfish.jersey.examples.hello.spring.annotations.EnglishGoodbyeService;
import org.glassfish.jersey.examples.hello.spring.annotations.GoodbyeService;
import org.glassfish.jersey.examples.hello.spring.annotations.GreetingService;
import org.glassfish.jersey.examples.hello.spring.annotations.NorwegianGoodbyeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Singleton
@Path(value="spring-resource")
@Service
public class SpringRequestResource {
    AtomicInteger counter = new AtomicInteger();
    @Autowired
    private GreetingService greetingService;
    @Autowired
    private List<GoodbyeService> goodbyeServicesList;
    @Autowired
    private Set<GoodbyeService> goodbyeServicesSet;
    @Autowired
    private Iterable<GoodbyeService> goodbyeServicesIterable;

    @GET
    @Produces(value={"text/plain"})
    public String getHello() {
        return this.greetingService.greet("world " + this.counter.incrementAndGet());
    }

    private void checkIntegrity() {
        Iterator<GoodbyeService> it = this.goodbyeServicesIterable.iterator();
        int i = 0;
        while (it.hasNext()) {
            GoodbyeService s2;
            GoodbyeService s1 = it.next();
            if (s1 != (s2 = this.goodbyeServicesList.get(i))) {
                throw new ProcessingException("Instance of service s1 (" + s1.getClass() + ") is not equal to service s2(" + s2.getClass() + ")");
            }
            ++i;
        }
        if (this.goodbyeServicesList.size() != this.goodbyeServicesSet.size()) {
            throw new ProcessingException("Size of set and size of the list differs. list=" + this.goodbyeServicesList.size() + "; set=" + this.goodbyeServicesSet.size());
        }
    }

    private GoodbyeService getService(Class<?> serviceClass) {
        for (GoodbyeService service : this.goodbyeServicesList) {
            if (!serviceClass.isAssignableFrom(service.getClass())) continue;
            return service;
        }
        return null;
    }

    @Path(value="goodbye")
    @GET
    @Produces(value={"text/plain"})
    public String getGoodbye() {
        this.checkIntegrity();
        GoodbyeService goodbyeService = this.getService(EnglishGoodbyeService.class);
        return goodbyeService.goodbye("cruel world");
    }

    @Path(value="norwegian-goodbye")
    @GET
    @Produces(value={"text/plain"})
    public String getNorwegianGoodbye() {
        this.checkIntegrity();
        return this.getService(NorwegianGoodbyeService.class).goodbye("p\u00e5 badet");
    }
}

