/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.core.Application;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.helloworld.AppScopedResource;
import org.glassfish.jersey.examples.helloworld.CustomInterceptor;
import org.glassfish.jersey.examples.helloworld.HelloWorldResource;
import org.glassfish.jersey.examples.helloworld.RequestScopedResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.jboss.weld.environment.se.Weld;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/weld/");
    public static final String ROOT_PATH = "application.wadl";

    public static void main(String[] args) {
        try {
            System.out.println("\"Hello World\" Jersey Example Weld App");
            Weld weld = new Weld();
            weld.initialize();
            ResourceConfig resourceConfig = App.createJaxRsApp();
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)resourceConfig);
            System.out.println(String.format("Application started.\nTry out %s%s\nHit enter to stop it...", BASE_URI, ROOT_PATH));
            System.in.read();
            server.shutdownNow();
            weld.shutdown();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig createJaxRsApp() {
        return ResourceConfig.forApplicationClass(JaxRsApplication.class);
    }

    @ApplicationScoped
    public static class JaxRsApplication
    extends Application {
        static final Set<Class<?>> appClasses = new HashSet();

        public Set<Class<?>> getClasses() {
            return appClasses;
        }

        static {
            appClasses.add(HelloWorldResource.class);
            appClasses.add(AppScopedResource.class);
            appClasses.add(RequestScopedResource.class);
            appClasses.add(CustomInterceptor.class);
        }
    }
}

