/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.helloworld;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.glassfish.jersey.examples.helloworld.App;
import org.glassfish.jersey.examples.helloworld.AppScopedResource;
import org.glassfish.jersey.examples.helloworld.RequestScopedBean;
import org.glassfish.jersey.examples.helloworld.ResponseBodyFromCdiBean;

@RequestScoped
@Path(value="req")
public class RequestScopedResource {
    @Inject
    AppScopedResource appResource;
    @Inject
    RequestScopedBean bean;
    private static final Executor executor = Executors.newCachedThreadPool();
    @Context
    UriInfo uriInfo;
    @Inject
    App.JaxRsApplication jaxRsApplication;

    @GET
    @Path(value="app/counter")
    public int getCounter() {
        return this.appResource.getCount();
    }

    @GET
    @Path(value="myself")
    public String getMyself() {
        return this.toString();
    }

    @GET
    @Path(value="parameterized")
    @ResponseBodyFromCdiBean
    public String interceptedParameterized(@QueryParam(value="q") String q) {
        this.bean.setRequestId(q);
        return "does not matter";
    }

    @GET
    @Path(value="straight")
    public String parameterizedStraight(@QueryParam(value="q") String q) {
        return "straight: " + q;
    }

    @GET
    @Path(value="parameterized-async")
    @ResponseBodyFromCdiBean
    public void interceptedParameterizedAsync(@QueryParam(value="q") String q, final @Suspended AsyncResponse response) {
        this.bean.setRequestId(q);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(RequestScopedResource.class.getName()).log(Level.SEVERE, null, ex);
                }
                response.resume((Object)"this will never make it to the client");
            }
        });
    }

    @GET
    @Path(value="ui/jax-rs-field/{d}")
    public String getJaxRsInjectedUIUri() {
        if (this.uriInfo == this.jaxRsApplication.uInfo) {
            throw new IllegalStateException("UriInfo injected into req scoped cdi bean should not get proxied.");
        }
        return this.uriInfo.getRequestUri().toString();
    }

    @GET
    @Path(value="ui/jax-rs-app-field/{d}")
    public String getCdiInjectedJaxRsAppUri() {
        return this.jaxRsApplication.uInfo.getRequestUri().toString();
    }
}

