/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.httptrace;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Request;

public class Stringifier {
    private Stringifier() {
    }

    public static String stringify(Request request) {
        StringBuilder buffer = new StringBuilder();
        Stringifier.printRequestLine(buffer, request);
        Stringifier.printPrefixedHeaders(buffer, (Map<String, List<String>>)request.getHeaders().asMap());
        if (request.hasEntity()) {
            buffer.append((String)request.readEntity(String.class)).append("\n");
        }
        return buffer.toString();
    }

    private static void printRequestLine(StringBuilder buffer, Request request) {
        buffer.append(request.getMethod()).append(" ").append(request.getUri().toASCIIString()).append("\n");
    }

    private static void printPrefixedHeaders(StringBuilder buffer, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            List<String> val = e.getValue();
            String header = e.getKey();
            if (val.size() == 1) {
                buffer.append(header).append(": ").append(val.get(0)).append("\n");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            boolean add = false;
            for (String s : val) {
                if (add) {
                    sb.append(',');
                }
                add = true;
                sb.append(s);
            }
            buffer.append(header).append(": ").append(sb.toString()).append("\n");
        }
    }
}

