/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.httptrace;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.httptrace.Stringifier;
import org.glassfish.jersey.examples.httptrace.TracingResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:9998/base/");
    public static final String ROOT_PATH_PROGRAMMATIC = "tracing/programmatic";
    public static final String ROOT_PATH_ANNOTATED = "tracing/annotated";

    public static void main(String[] args) {
        try {
            System.out.println("HTTP TRACE Support Jersey Example App");
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)App.create());
            System.out.println(String.format("Application started.\nTo test TRACE with a programmatic resource, send HTTP TRACE request to:%n  %s%s%nTo test TRACE with an annotated resource, send HTTP TRACE request to:%n  %s%s%nHit enter to stop it...", BASE_URI, ROOT_PATH_PROGRAMMATIC, BASE_URI, ROOT_PATH_ANNOTATED));
            System.in.read();
            server.shutdownNow();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig create() {
        ResourceConfig resourceConfig = new ResourceConfig(new Class[]{TracingResource.class});
        Resource.Builder resourceBuilder = Resource.builder((String)ROOT_PATH_PROGRAMMATIC);
        resourceBuilder.addMethod("TRACE").handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext request) {
                if (request == null) {
                    return Response.noContent().build();
                }
                return Response.ok((Object)Stringifier.stringify((ContainerRequest)request), (String)"text/plain").build();
            }
        });
        return resourceConfig.registerResources(new Resource[]{resourceBuilder.build()});
    }
}

