/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.httpsclientservergrizzly;

import java.io.IOException;
import java.security.Principal;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.FilterContext;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.RequestFilter;
import org.glassfish.jersey.examples.httpsclientservergrizzly.AuthenticationException;
import org.glassfish.jersey.internal.util.Base64;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.jvnet.hk2.annotations.Inject;

@Provider
public class SecurityFilter
implements RequestFilter {
    @Inject
    UriInfo uriInfo;
    private static final String REALM = "HTTPS Example authentication";
    @Inject
    Ref<SecurityContext> securityContextRef;

    public void preFilter(FilterContext filterContext) throws IOException {
        User user = this.authenticate(filterContext.getRequest());
        this.securityContextRef.set((Object)new Authorizer(user));
    }

    private User authenticate(Request request) {
        String authentication = request.getHeaders().getHeader("Authorization");
        if (authentication == null) {
            throw new AuthenticationException("Authentication credentials are required", REALM);
        }
        if (!authentication.startsWith("Basic ")) {
            return null;
        }
        String[] values = new String(Base64.decodeAsString((String)(authentication = authentication.substring("Basic ".length())))).split(":");
        if (values.length < 2) {
            throw new WebApplicationException(400);
        }
        String username = values[0];
        String password = values[1];
        if (username == null || password == null) {
            throw new WebApplicationException(400);
        }
        User user = null;
        if (!username.equals("user") || !password.equals("password")) {
            System.out.println("USER NOT AUTHENTICATED");
            throw new AuthenticationException("Invalid username or password\r\n", REALM);
        }
        user = new User("user", "user");
        System.out.println("USER AUTHENTICATED");
        return user;
    }

    public class User {
        public String username;
        public String role;

        public User(String username, String role) {
            this.username = username;
            this.role = role;
        }
    }

    public class Authorizer
    implements SecurityContext {
        private User user;
        private Principal principal;

        public Authorizer(final User user) {
            this.user = user;
            this.principal = new Principal(){

                @Override
                public String getName() {
                    return user.username;
                }
            };
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return role.equals(this.user.role);
        }

        public boolean isSecure() {
            return "https".equals(SecurityFilter.this.uriInfo.getRequestUri().getScheme());
        }

        public String getAuthenticationScheme() {
            return "BASIC";
        }
    }
}

