/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.httpsclientservergrizzly;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.examples.httpsclientservergrizzly.AuthenticationExceptionMapper;
import org.glassfish.jersey.examples.httpsclientservergrizzly.RootResource;
import org.glassfish.jersey.examples.httpsclientservergrizzly.SecurityFilter;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.server.ResourceConfig;

public class Server {
    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    private static final String KEYSTORE_SERVER_FILE = "./keystore_server";
    private static final String KEYSTORE_SERVER_PWD = "asdfgh";
    private static final String TRUSTORE_SERVER_FILE = "./truststore_server";
    private static final String TRUSTORE_SERVER_PWD = "asdfgh";
    public static final URI BASE_URI = Server.getBaseURI();
    public static final String CONTENT = "JERSEY HTTPS EXAMPLE\n";
    private final HttpServer webServer;

    private Server(HttpServer webServer) {
        this.webServer = webServer;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"https://localhost/").port(Server.getPort(8463)).build(new Object[0]);
    }

    private static int getPort(int defaultPort) {
        String port = (String)AccessController.doPrivileged(PropertiesHelper.getSystemProperty((String)"jersey.config.test.container.port"));
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                LOGGER.warning("Value of jersey.config.test.container.port property is not a valid positive integer [" + port + "]." + " Reverting to default [" + defaultPort + "].");
            }
        }
        return defaultPort;
    }

    public static Server start() throws IOException {
        SSLContextConfigurator sslContext = new SSLContextConfigurator();
        sslContext.setKeyStoreFile(KEYSTORE_SERVER_FILE);
        sslContext.setKeyStorePass("asdfgh");
        sslContext.setTrustStoreFile(TRUSTORE_SERVER_FILE);
        sslContext.setTrustStorePass("asdfgh");
        ResourceConfig rc = new ResourceConfig();
        rc.registerClasses(new Class[]{RootResource.class, SecurityFilter.class, AuthenticationExceptionMapper.class});
        HttpServer grizzlyServer = GrizzlyHttpServerFactory.createHttpServer((URI)Server.getBaseURI(), (ResourceConfig)rc, (boolean)true, (SSLEngineConfigurator)new SSLEngineConfigurator(sslContext).setClientMode(false).setNeedClientAuth(true));
        LOGGER.info("Jersey app started. Try out " + BASE_URI + "\nHit CTRL + C to stop it...");
        grizzlyServer.start();
        return new Server(grizzlyServer);
    }

    public void stop() {
        this.webServer.shutdownNow();
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        Server.start();
        System.in.read();
    }
}

