/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.httpsclientservergrizzly;

import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Principal;
import org.glassfish.jersey.examples.httpsclientservergrizzly.AuthenticationException;

@Provider
@PreMatching
public class SecurityFilter
implements ContainerRequestFilter {
    @Inject
    jakarta.inject.Provider<UriInfo> uriInfo;
    private static final String REALM = "HTTPS Example authentication";

    public void filter(ContainerRequestContext filterContext) throws IOException {
        User user = this.authenticate(filterContext);
        filterContext.setSecurityContext((SecurityContext)new Authorizer(user));
    }

    private User authenticate(ContainerRequestContext filterContext) {
        String authentication = filterContext.getHeaderString("Authorization");
        if (authentication == null) {
            throw new AuthenticationException("Authentication credentials are required", REALM);
        }
        if (!authentication.startsWith("Basic ")) {
            return null;
        }
        String[] values = new String(DatatypeConverter.parseBase64Binary((String)(authentication = authentication.substring("Basic ".length()))), Charset.forName("ASCII")).split(":");
        if (values.length < 2) {
            throw new WebApplicationException(400);
        }
        String username = values[0];
        String password = values[1];
        if (username == null || password == null) {
            throw new WebApplicationException(400);
        }
        if (!username.equals("user") || !password.equals("password")) {
            System.out.println("USER NOT AUTHENTICATED");
            throw new AuthenticationException("Invalid username or password\r\n", REALM);
        }
        User user = new User("user", "user");
        System.out.println("USER AUTHENTICATED");
        return user;
    }

    public class User {
        public String username;
        public String role;

        public User(String username, String role) {
            this.username = username;
            this.role = role;
        }
    }

    public class Authorizer
    implements SecurityContext {
        private User user;
        private Principal principal;

        public Authorizer(final User user) {
            this.user = user;
            this.principal = new Principal(){

                @Override
                public String getName() {
                    return user.username;
                }
            };
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return role.equals(this.user.role);
        }

        public boolean isSecure() {
            return "https".equals(((UriInfo)SecurityFilter.this.uriInfo.get()).getRequestUri().getScheme());
        }

        public String getAuthenticationScheme() {
            return "BASIC";
        }
    }
}

