/*
 * Copyright (c) 2015, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.jersey.examples.java8.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

/**
 * JAX-RS resource inheriting some resource method implementations from the implemented interface.
 *
 * @author Adam Lindenthal
 */
@Path("default-method")
@Produces("text/plain")
public class DefaultMethodResource implements DefaultMethodInterface {

    @GET
    @Path("class")
    public String fromClass() {
        return "class";
    }
}
