/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.jersey_ejb.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.examples.jersey_ejb.entities.Message;
import org.glassfish.jersey.examples.jersey_ejb.exceptions.CustomNotFoundException;
import org.glassfish.jersey.examples.jersey_ejb.resources.MessageHolderSingletonBean;

@Stateless
public class MessageBoardResourceBean {
    @Context
    private UriInfo ui;
    @EJB
    MessageHolderSingletonBean singleton;

    @GET
    public List<Message> getMessages() {
        return this.singleton.getMessages();
    }

    @POST
    public Response addMessage(String msg) throws URISyntaxException {
        Message m = this.singleton.addMessage(msg);
        URI msgURI = this.ui.getRequestUriBuilder().path(Integer.toString(m.getUniqueId())).build(new Object[0]);
        return Response.created((URI)msgURI).build();
    }

    @Path(value="{msgNum}")
    @GET
    public Message getMessage(@PathParam(value="msgNum") int msgNum) {
        Message m = this.singleton.getMessage(msgNum);
        if (m == null) {
            throw new NotFoundException();
        }
        return m;
    }

    @Path(value="{msgNum}")
    @DELETE
    public void deleteMessage(@PathParam(value="msgNum") int msgNum) throws CustomNotFoundException {
        boolean deleted = this.singleton.deleteMessage(msgNum);
        if (!deleted) {
            throw new CustomNotFoundException();
        }
    }
}

