/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.jersey_ejb.resources;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ejb.Singleton;
import org.glassfish.jersey.examples.jersey_ejb.entities.Message;

@Singleton
public class MessageHolderSingletonBean {
    private List<Message> list = new CopyOnWriteArrayList();
    private int maxMessages = 10;
    int currentId = 0;

    public MessageHolderSingletonBean() {
        this.addMessage("msg0", new Date(0L));
        this.addMessage("msg1", new Date(1000L));
        this.addMessage("msg2", new Date(2000L));
    }

    public List<Message> getMessages() {
        LinkedList<Message> l = new LinkedList<Message>();
        for (int index = 0; index < this.list.size() && index < this.maxMessages; ++index) {
            l.add((Message)this.list.get(index));
        }
        return l;
    }

    private int getNewId() {
        return this.currentId++;
    }

    public Message addMessage(String msg) {
        return this.addMessage(msg, new Date());
    }

    private Message addMessage(String msg, Date date) {
        Message m = new Message(date, msg, this.getNewId());
        this.list.add(0, m);
        return m;
    }

    public Message getMessage(int uniqueId) {
        for (int index = 0; index < this.list.size(); ++index) {
            Message m = (Message)this.list.get(index);
            if (m.getUniqueId() != uniqueId) continue;
            return m;
        }
        return null;
    }

    public boolean deleteMessage(int uniqueId) {
        for (int index = 0; index < this.list.size(); ++index) {
            if (((Message)this.list.get(index)).getUniqueId() != uniqueId) continue;
            this.list.remove(index);
            return true;
        }
        return false;
    }
}

