/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.jersey_ejb.entities;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Provider;
import org.glassfish.jersey.examples.jersey_ejb.entities.Message;
import org.glassfish.jersey.message.MessageUtils;

@Stateless
@jakarta.ws.rs.ext.Provider
public class MessageListWriter
implements MessageBodyWriter<List<Message>> {
    @Context
    private Provider<UriInfo> ui;

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotation, MediaType mediaType) {
        return this.verifyGenericType(type);
    }

    private boolean verifyGenericType(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        if (pt.getActualTypeArguments().length > 1) {
            return false;
        }
        if (!(pt.getActualTypeArguments()[0] instanceof Class)) {
            return false;
        }
        Class listClass = (Class)pt.getActualTypeArguments()[0];
        return listClass == Message.class;
    }

    public long getSize(List<Message> messages, Class<?> clazz, Type type, Annotation[] annotation, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(List<Message> messages, Class<?> clazz, Type type, Annotation[] annotation, MediaType mediaType, MultivaluedMap<String, Object> arg5, OutputStream ostream) throws IOException, WebApplicationException {
        for (Message m : messages) {
            ostream.write(m.toString().getBytes(MessageUtils.getCharset((MediaType)mediaType)));
            URI mUri = ((UriInfo)this.ui.get()).getAbsolutePathBuilder().path(Integer.toString(m.getUniqueId())).build(new Object[0]);
            ostream.write((" <a href='" + mUri.toASCIIString() + "'>link</a><br />").getBytes());
        }
    }
}

