/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.jersey_ejb.resources;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.glassfish.jersey.examples.jersey_ejb.entities.Message;
import org.glassfish.jersey.examples.jersey_ejb.exceptions.CustomNotFoundException;
import org.glassfish.jersey.examples.jersey_ejb.resources.MessageHolderSingletonBean;

@Stateless
public class MessageBoardResourceBean {
    @Context
    private UriInfo ui;
    @EJB
    MessageHolderSingletonBean singleton;

    @GET
    public List<Message> getMessages() {
        return this.singleton.getMessages();
    }

    @POST
    public Response addMessage(String msg) throws URISyntaxException {
        Message m = this.singleton.addMessage(msg);
        URI msgURI = this.ui.getRequestUriBuilder().path(Integer.toString(m.getUniqueId())).build(new Object[0]);
        return Response.created((URI)msgURI).build();
    }

    @Path(value="{msgNum}")
    @GET
    public Message getMessage(@PathParam(value="msgNum") int msgNum) {
        Message m = this.singleton.getMessage(msgNum);
        if (m == null) {
            throw new NotFoundException();
        }
        return m;
    }

    @Path(value="{msgNum}")
    @DELETE
    public void deleteMessage(@PathParam(value="msgNum") int msgNum) throws CustomNotFoundException {
        boolean deleted = this.singleton.deleteMessage(msgNum);
        if (!deleted) {
            throw new CustomNotFoundException();
        }
    }
}

