/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.examples.micrometer.MetricsStore;

@Path(value="summary")
public class SummaryResource {
    @Context
    private MetricsStore store;

    @GET
    @Produces(value={"text/html"})
    public String getExtendedMeters() {
        StringBuffer result = new StringBuffer();
        try {
            result.append("<html><body>Listing available meters<br/><br/>Many occurrences of the same name means that there are more meters which could be used with different tags, but this is actually a challenge to handle all available metrics :<br/><br/> ");
            for (Meter meter : this.store.getRegistry().getMeters()) {
                result.append(meter.getId().getName());
                result.append(";<br/>\n\r ");
            }
        }
        catch (Exception ex) {
            result.append("Try clicking links below to gain more metrics.<br/>");
        }
        result.append("<br/>\n\r ");
        result.append("<br/>\n\r ");
        try {
            Timer timer = this.store.getRegistry().get("http.shared.metrics").tags(new String[]{"method", "GET", "status", "200", "exception", "None", "outcome", "SUCCESS", "uri", "/micro/metrics"}).timer();
            result.append(String.format("Counts to the page with standard measurements: %d, time spent on requests to the init page (millis): %f <br/>\n\r", timer.count(), timer.totalTime(TimeUnit.MILLISECONDS)));
            Timer annotatedTimer = this.store.getRegistry().timer("http.timers", new String[]{"method", "GET", "status", "200", "exception", "None", "outcome", "SUCCESS", "uri", "/micro/timed"});
            result.append(String.format("Counts to the page with annotated measurements: %d, total time (millis): %f <br/>\n\r", annotatedTimer.count(), annotatedTimer.totalTime(TimeUnit.MILLISECONDS)));
        }
        catch (Exception ex) {
            result.append(String.format("Counts to the init page: %d, total time (millis): %d <br/>\n\r", 0, 0));
            result.append("Try clicking links below to gain more metrics.<br/>");
        }
        result.append("<br/><br/>Available pages for measurements: <a href=\"/micro/metrics\">measure requests in the standard way</a> &nbsp;, <a href=\"/micro/timed\">measure requests in the annotated way</a>");
        return result.append("</body></html>").toString();
    }
}

