/*
 * Copyright (c) 2010, 2019 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.jersey.examples.jettison;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * TODO javadoc.
 *
 * @author Jakub Podlesak
 * @author Marek Potociar
 */
@Path("/aircrafts")
public class AircraftTypeList {

    static final List<AircraftType> aircraftTypes = new LinkedList<AircraftType>();

    static {
        aircraftTypes.add(new AircraftType("B737", 42.1, 204));
        aircraftTypes.add(new AircraftType("A330", 58.8, 253));
    }

    @GET
    @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
    public List<AircraftType> getAircraftTypes() {
        return aircraftTypes;
    }
}
