/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.jsonp.service;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.json.JsonObject;
import jersey.repackaged.com.google.common.collect.Maps;

public final class DocumentStorage {
    private static final Map<Integer, JsonObject> storage = Maps.newLinkedHashMap();
    private static final AtomicInteger counter = new AtomicInteger(0);

    public static int store(JsonObject document) {
        int id = counter.addAndGet(1);
        storage.put(id, document);
        return id;
    }

    public static JsonObject get(int id) {
        return (JsonObject)storage.get(id);
    }

    public static Collection<JsonObject> getAll() {
        return storage.values();
    }

    public static JsonObject remove(int id) {
        return (JsonObject)storage.remove(id);
    }

    public static void removeAll() {
        storage.clear();
    }

    private DocumentStorage() {
    }
}

