/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.jsonp.resource;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.glassfish.jersey.examples.jsonp.resource.DocumentFilteringResource;
import org.glassfish.jersey.examples.jsonp.service.DocumentStorage;

@Path(value="document")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DocumentResource {
    @GET
    public JsonArray getAll() {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (JsonObject document : DocumentStorage.getAll()) {
            arrayBuilder.add((JsonValue)document);
        }
        return arrayBuilder.build();
    }

    @GET
    @Path(value="{id: \\d+}")
    public JsonObject get(@PathParam(value="id") int id) {
        return DocumentStorage.get((int)id);
    }

    @DELETE
    @Path(value="{id: \\d+}")
    public JsonObject remove(@PathParam(value="id") int id) {
        return DocumentStorage.remove((int)id);
    }

    @DELETE
    public void removeAll() {
        DocumentStorage.removeAll();
    }

    @POST
    public JsonArray store(JsonObject document) {
        return Json.createArrayBuilder().add(DocumentStorage.store((JsonObject)document)).build();
    }

    @POST
    @Path(value="multiple")
    public JsonArray store(JsonArray documents) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (JsonObject document : documents.getValuesAs(JsonObject.class)) {
            arrayBuilder.add(DocumentStorage.store((JsonObject)document));
        }
        return arrayBuilder.build();
    }

    @Path(value="filter")
    public Class<DocumentFilteringResource> getFilteringResource() {
        return DocumentFilteringResource.class;
    }
}

