/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.managedbeans.resources;

import com.sun.jersey.samples.managedbeans.resources.ManagedBeanException;
import com.sun.jersey.samples.managedbeans.resources.Widget;
import javax.annotation.ManagedBean;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/managedbean/singleton")
@Singleton
@ManagedBean
public class ManagedBeanSingletonResource {
    @Resource(name="injectedResource")
    int counter = 0;
    @Context
    UriInfo ui;
    private EntityManager entityManager;

    @PersistenceUnit(unitName="ManagedBeansPU")
    void setEntityManager(EntityManagerFactory em) {
        this.entityManager = em.createEntityManager();
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return Integer.toString(this.counter++);
    }

    @PUT
    @Produces(value={"text/plain"})
    public void putMessage(int i) {
        this.counter = i;
    }

    @Path(value="exception")
    public String getException() {
        throw new ManagedBeanException();
    }

    @Path(value="widget/{id: \\d+}")
    @GET
    public String getWidget(@PathParam(value="id") int id) {
        try {
            return ((Widget)this.entityManager.find(Widget.class, (Object)Integer.valueOf((int)id))).val;
        }
        catch (NullPointerException ignored) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @Path(value="widget/{id: \\d+}")
    @PUT
    public void putWidget(@PathParam(value="id") int id, String val) {
        this.entityManager.merge((Object)new Widget(id, val));
    }

    @Path(value="widget/{id: \\d+}")
    @DELETE
    public void deleteWidget(@PathParam(value="id") int id) {
        this.entityManager.remove(this.entityManager.find(Widget.class, (Object)id));
    }
}

