/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.managedbeans.resources;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import javax.annotation.ManagedBean;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.glassfish.jersey.examples.managedbeans.resources.ManagedBeanException;
import org.glassfish.jersey.examples.managedbeans.resources.Widget;

@Path(value="/managedbean/singleton")
@Singleton
@ManagedBean
public class ManagedBeanSingletonResource {
    @Resource(name="injectedResource")
    int counter = 0;
    @Context
    UriInfo ui;
    private EntityManager entityManager;

    @PersistenceUnit(unitName="ManagedBeansPU")
    void setEntityManager(EntityManagerFactory em) {
        this.entityManager = em.createEntityManager();
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return Integer.toString(this.counter++);
    }

    @PUT
    @Produces(value={"text/plain"})
    public void putMessage(int i) {
        this.counter = i;
    }

    @Path(value="exception")
    public String getException() {
        throw new ManagedBeanException();
    }

    @Path(value="widget/{id: \\d+}")
    @GET
    public String getWidget(@PathParam(value="id") int id) {
        try {
            return ((Widget)this.entityManager.find(Widget.class, (Object)Integer.valueOf((int)id))).val;
        }
        catch (NullPointerException ignored) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @Path(value="widget/{id: \\d+}")
    @PUT
    public void putWidget(@PathParam(value="id") int id, String val) {
        this.entityManager.merge((Object)new Widget(id, val));
    }

    @Path(value="widget/{id: \\d+}")
    @DELETE
    public void deleteWidget(@PathParam(value="id") int id) {
        this.entityManager.remove(this.entityManager.find(Widget.class, (Object)id));
    }
}

