/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.managedbeans.resources;

import jakarta.annotation.ManagedBean;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.glassfish.jersey.examples.managedbeans.resources.ManagedBeanException;

@Provider
@ManagedBean
public class ManagedBeanExceptionMapper
implements ExceptionMapper<ManagedBeanException> {
    @Context
    private UriInfo uiFieldInject;
    @Context
    private ResourceContext rc;
    private UriInfo uiMethodInject;
    private UriInfo ui;

    @Context
    public void set(UriInfo ui) {
        this.uiMethodInject = ui;
    }

    @PostConstruct
    public void postConstruct() {
        this.ensureInjected();
        this.ui = this.uiMethodInject;
    }

    public Response toResponse(ManagedBeanException exception) {
        this.ensureInjected();
        return Response.serverError().entity((Object)String.format("ManagedBeanException from %s", this.ui.getPath())).build();
    }

    private void ensureInjected() throws IllegalStateException {
        if (this.uiFieldInject == null || this.uiMethodInject == null || this.rc == null) {
            throw new IllegalStateException();
        }
    }
}

