/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.managedclient;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.examples.managedclient.ClientA;
import org.glassfish.jersey.examples.managedclient.CustomHeaderFeature;
import org.glassfish.jersey.examples.managedclient.CustomHeaderFilter;
import org.glassfish.jersey.examples.managedclient.InternalResource;
import org.glassfish.jersey.examples.managedclient.PublicResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/managedclient/");

    public static void main(String[] args) {
        try {
            System.out.println("\"Managed Client\" Jersey Example App");
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)App.create());
            System.out.println(String.format("Application started.\nTry out public endpoints:\n  %s%s\n  %s%s\nHit enter to stop it...", BASE_URI, "public/a", BASE_URI, "public/b"));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, "Error in the IO container.", ex);
        }
    }

    public static ResourceConfig create() {
        return new ResourceConfig(new Class[]{PublicResource.class, InternalResource.class, CustomHeaderFeature.class}).property(ClientA.class.getName() + ".baseUri", (Object)(BASE_URI.toString() + "internal"));
    }

    public static class MyClientBConfig
    extends ClientConfig {
        public MyClientBConfig() {
            this.register(new CustomHeaderFilter("custom-header", "b"));
        }
    }

    public static class MyClientAConfig
    extends ClientConfig {
        public MyClientAConfig() {
            this.register(new CustomHeaderFilter("custom-header", "a"));
        }
    }
}

