/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.oauth.twitterclient;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.oauth1.AccessToken;
import org.glassfish.jersey.client.oauth1.ConsumerCredentials;
import org.glassfish.jersey.client.oauth1.OAuth1AuthorizationFlow;
import org.glassfish.jersey.client.oauth1.OAuth1ClientSupport;
import org.glassfish.jersey.examples.oauth.twitterclient.Status;
import org.glassfish.jersey.jackson.JacksonFeature;

public class App {
    private static final BufferedReader IN = new BufferedReader(new InputStreamReader(System.in));
    private static final String FRIENDS_TIMELINE_URI = "https://api.twitter.com/1.1/statuses/home_timeline.json";
    private static final Properties PROPERTIES = new Properties();
    private static final String PROPERTIES_FILE_NAME = "twitterclient.properties";
    private static final String PROPERTY_CONSUMER_KEY = "consumerKey";
    private static final String PROPERTY_CONSUMER_SECRET = "consumerSecret";
    private static final String PROPERTY_TOKEN = "token";
    private static final String PROPERTY_TOKEN_SECRET = "tokenSecret";

    public static void main(String[] args) throws Exception {
        Feature filterFeature;
        App.loadSettings();
        ConsumerCredentials consumerCredentials = new ConsumerCredentials(PROPERTIES.getProperty(PROPERTY_CONSUMER_KEY), PROPERTIES.getProperty(PROPERTY_CONSUMER_SECRET));
        if (PROPERTIES.getProperty(PROPERTY_TOKEN) == null) {
            OAuth1AuthorizationFlow authFlow = OAuth1ClientSupport.builder((ConsumerCredentials)consumerCredentials).authorizationFlow("https://api.twitter.com/oauth/request_token", "https://api.twitter.com/oauth/access_token", "https://api.twitter.com/oauth/authorize").build();
            String authorizationUri = authFlow.start();
            System.out.println("Enter the following URI into a web browser and authorize me:");
            System.out.println(authorizationUri);
            System.out.print("Enter the authorization code: ");
            String verifier = null;
            try {
                verifier = IN.readLine();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            AccessToken accessToken = authFlow.finish(verifier);
            PROPERTIES.setProperty(PROPERTY_TOKEN, accessToken.getToken());
            PROPERTIES.setProperty(PROPERTY_TOKEN_SECRET, accessToken.getAccessTokenSecret());
            filterFeature = authFlow.getOAuth1Feature();
        } else {
            AccessToken storedToken = new AccessToken(PROPERTIES.getProperty(PROPERTY_TOKEN), PROPERTIES.getProperty(PROPERTY_TOKEN_SECRET));
            filterFeature = OAuth1ClientSupport.builder((ConsumerCredentials)consumerCredentials).feature().accessToken(storedToken).build();
        }
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register((Object)filterFeature)).register(JacksonFeature.class)).build();
        Response response = client.target(FRIENDS_TIMELINE_URI).request().get();
        if (response.getStatus() != 200) {
            String errorEntity = null;
            if (response.hasEntity()) {
                errorEntity = (String)response.readEntity(String.class);
            }
            throw new RuntimeException("Request to Twitter was not successful. Response code: " + response.getStatus() + ", reason: " + response.getStatusInfo().getReasonPhrase() + ", entity: " + errorEntity);
        }
        App.storeSettings();
        List statuses = (List)response.readEntity((GenericType)new GenericType<List<Status>>(){});
        System.out.println("Tweets:\n");
        for (Status s : statuses) {
            System.out.println(s.getText());
            System.out.println("[posted by " + s.getUser().getName() + " at " + s.getCreatedAt() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSettings() {
        FileInputStream st = null;
        try {
            st = new FileInputStream(PROPERTIES_FILE_NAME);
            PROPERTIES.load(st);
        }
        catch (IOException e) {
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (IOException ex) {}
            }
        }
        for (String name : new String[]{PROPERTY_CONSUMER_KEY, PROPERTY_CONSUMER_SECRET, PROPERTY_TOKEN, PROPERTY_TOKEN_SECRET}) {
            String value = System.getProperty(name);
            if (value == null) continue;
            PROPERTIES.setProperty(name, value);
        }
        if (PROPERTIES.getProperty(PROPERTY_CONSUMER_KEY) == null || PROPERTIES.getProperty(PROPERTY_CONSUMER_SECRET) == null) {
            System.out.println("No consumerKey and/or consumerSecret found in twitterclient.properties file. You have to provide these as system properties. See README.html for more information.");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeSettings() {
        FileOutputStream st = null;
        try {
            st = new FileOutputStream(PROPERTIES_FILE_NAME);
            PROPERTIES.store(st, null);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (IOException ex) {}
        }
    }
}

