/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.oauth2.googleclient.resource;

import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.client.oauth2.ClientIdentifier;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;
import org.glassfish.jersey.client.oauth2.OAuth2CodeGrantFlow;
import org.glassfish.jersey.client.oauth2.OAuth2FlowGoogleBuilder;
import org.glassfish.jersey.examples.oauth2.googleclient.SimpleOAuthService;
import org.glassfish.jersey.examples.oauth2.googleclient.entity.TaskBean;
import org.glassfish.jersey.examples.oauth2.googleclient.entity.TaskListBean;
import org.glassfish.jersey.examples.oauth2.googleclient.entity.TaskRootBean;
import org.glassfish.jersey.examples.oauth2.googleclient.model.AllTaskListsModel;
import org.glassfish.jersey.examples.oauth2.googleclient.model.TaskListModel;
import org.glassfish.jersey.examples.oauth2.googleclient.model.TaskModel;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.mvc.Template;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="tasks")
public class TaskResource {
    private static final String GOOGLE_TASKS_BASE_URI = "https://www.googleapis.com/tasks/v1/";
    @Context
    private UriInfo uriInfo;

    @GET
    @Template(name="/tasks.mustache")
    @Produces(value={"text/html"})
    public Response getTasks() {
        if (SimpleOAuthService.getAccessToken() == null) {
            String redirectURI = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path("oauth2/authorize").build(new Object[0]).toString();
            OAuth2CodeGrantFlow flow = OAuth2ClientSupport.googleFlowBuilder((ClientIdentifier)SimpleOAuthService.getClientIdentifier(), (String)redirectURI, (String)"https://www.googleapis.com/auth/tasks.readonly").prompt(OAuth2FlowGoogleBuilder.Prompt.CONSENT).build();
            SimpleOAuthService.setFlow((OAuth2CodeGrantFlow)flow);
            String googleAuthURI = flow.start();
            return Response.seeOther((URI)UriBuilder.fromUri((String)googleAuthURI).build(new Object[0])).build();
        }
        Client client = SimpleOAuthService.getFlow().getAuthorizedClient();
        AllTaskListsModel allTaskListsModel = TaskResource.getTasks((Client)client);
        return Response.ok((Object)allTaskListsModel).type(MediaType.TEXT_HTML_TYPE).build();
    }

    private static AllTaskListsModel getTasks(Client client) {
        client.register(JacksonFeature.class);
        WebTarget baseTarget = client.target("https://www.googleapis.com/tasks/v1/");
        Response response = baseTarget.path("users/@me/lists").request().get();
        StringBuilder sb = new StringBuilder();
        TaskRootBean taskRootBean = (TaskRootBean)response.readEntity(TaskRootBean.class);
        ArrayList<TaskListModel> listOfTaskLists = new ArrayList<TaskListModel>();
        for (TaskListBean taskListBean : taskRootBean.getItems()) {
            ArrayList<TaskModel> taskList = new ArrayList<TaskModel>();
            WebTarget listTarget = baseTarget.path("lists/{tasklist}/tasks").resolveTemplate("tasklist", (Object)taskListBean.getId());
            TaskListBean fullTaskListBean = (TaskListBean)listTarget.request().get(TaskListBean.class);
            for (TaskBean taskBean : fullTaskListBean.getTasks()) {
                taskList.add(new TaskModel(taskBean.getTitle()));
            }
            TaskListModel listModel = new TaskListModel(taskListBean == null ? "No tasks were found. Define some tasks." : taskListBean.getTitle(), taskList);
            listOfTaskLists.add(listModel);
        }
        return new AllTaskListsModel(listOfTaskLists);
    }
}

