/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.oauth2.googleclient.resource;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.client.oauth2.ClientIdentifier;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;
import org.glassfish.jersey.client.oauth2.OAuth2CodeGrantFlow;
import org.glassfish.jersey.client.oauth2.OAuth2FlowGoogleBuilder;
import org.glassfish.jersey.examples.oauth2.googleclient.SimpleOAuthService;
import org.glassfish.jersey.examples.oauth2.googleclient.entity.TaskBean;
import org.glassfish.jersey.examples.oauth2.googleclient.entity.TaskListBean;
import org.glassfish.jersey.examples.oauth2.googleclient.entity.TaskRootBean;
import org.glassfish.jersey.examples.oauth2.googleclient.model.AllTaskListsModel;
import org.glassfish.jersey.examples.oauth2.googleclient.model.TaskListModel;
import org.glassfish.jersey.examples.oauth2.googleclient.model.TaskModel;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.mvc.Template;

@Path(value="tasks")
public class TaskResource {
    private static final String GOOGLE_TASKS_BASE_URI = "https://www.googleapis.com/tasks/v1/";
    @Context
    private UriInfo uriInfo;
    @Context
    private ServletContext servletContext;

    @GET
    @Template(name="/tasks.mustache")
    @Produces(value={"text/html"})
    public Response getTasks() {
        if (SimpleOAuthService.getClientIdentifier() == null) {
            URI uri = UriBuilder.fromUri((String)this.servletContext.getContextPath()).path("/index.html").build(new Object[0]);
            return Response.seeOther((URI)uri).build();
        }
        if (SimpleOAuthService.getAccessToken() == null) {
            return this.googleAuthRedirect();
        }
        Client client = SimpleOAuthService.getFlow().getAuthorizedClient();
        return this.getTasksResponse(client);
    }

    private Response googleAuthRedirect() {
        String redirectURI = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path("oauth2/authorize").build(new Object[0]).toString();
        OAuth2CodeGrantFlow flow = OAuth2ClientSupport.googleFlowBuilder((ClientIdentifier)SimpleOAuthService.getClientIdentifier(), (String)redirectURI, (String)"https://www.googleapis.com/auth/tasks.readonly").prompt(OAuth2FlowGoogleBuilder.Prompt.CONSENT).build();
        SimpleOAuthService.setFlow((OAuth2CodeGrantFlow)flow);
        String googleAuthURI = flow.start();
        return Response.seeOther((URI)UriBuilder.fromUri((String)googleAuthURI).build(new Object[0])).build();
    }

    private Response getTasksResponse(Client client) {
        List listOfTaskLists;
        client.register(JacksonFeature.class);
        client.register((Object)new LoggingFeature(Logger.getLogger("example.client.tasks"), LoggingFeature.Verbosity.PAYLOAD_ANY));
        WebTarget baseTarget = client.target(GOOGLE_TASKS_BASE_URI);
        Response response = baseTarget.path("users/@me/lists").request().get();
        switch (response.getStatus()) {
            case 401: {
                SimpleOAuthService.setAccessToken(null);
                return this.googleAuthRedirect();
            }
            case 200: {
                listOfTaskLists = this.processTaskLists(baseTarget, (TaskRootBean)response.readEntity(TaskRootBean.class));
                break;
            }
            default: {
                listOfTaskLists = null;
            }
        }
        AllTaskListsModel tasks = new AllTaskListsModel(listOfTaskLists);
        return Response.ok((Object)tasks).build();
    }

    private List<TaskListModel> processTaskLists(WebTarget baseTarget, TaskRootBean taskRootBean) {
        ArrayList<TaskListModel> listOfTaskLists = new ArrayList<TaskListModel>();
        for (TaskListBean taskListBean : taskRootBean.getItems()) {
            ArrayList<TaskModel> taskList = new ArrayList<TaskModel>();
            WebTarget listTarget = baseTarget.path("lists/{tasklist}/tasks").resolveTemplate("tasklist", (Object)taskListBean.getId());
            TaskListBean fullTaskListBean = (TaskListBean)listTarget.request().get(TaskListBean.class);
            for (TaskBean taskBean : fullTaskListBean.getTasks()) {
                if (taskBean.getCompleted() != null) continue;
                taskList.add(new TaskModel(taskBean.getTitle()));
            }
            listOfTaskLists.add(new TaskListModel(taskListBean.getTitle(), taskList.size() > 0 ? taskList : null));
        }
        return listOfTaskLists.size() > 0 ? listOfTaskLists : null;
    }
}

