/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.oauth2.googleclient;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.client.oauth2.OAuth2CodeGrantFlow;
import org.glassfish.jersey.client.oauth2.TokenResult;
import org.glassfish.jersey.examples.oauth2.googleclient.CredentialStore;

@Path(value="oauth2")
public class AuthorizationResource {
    @Context
    private UriInfo uriInfo;

    @GET
    @Path(value="authorize")
    public Response authorize(@QueryParam(value="code") String code, @QueryParam(value="state") String state) {
        TokenResult tokenResult;
        OAuth2CodeGrantFlow flow = CredentialStore.cachedFlow;
        if (flow == null) {
            return Response.status((int)400).type("text/plain").entity((Object)"Authorization flow is not in progress.").build();
        }
        CredentialStore.tokenResult = tokenResult = flow.finish(code, state);
        URI uri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path("tasks").build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }
}

