/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.oauth2.googleclient;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.client.oauth2.ClientIdentifier;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;
import org.glassfish.jersey.client.oauth2.OAuth2CodeGrantFlow;
import org.glassfish.jersey.client.oauth2.OAuth2FlowGoogleBuilder;
import org.glassfish.jersey.client.oauth2.TokenResult;
import org.glassfish.jersey.examples.oauth2.googleclient.CredentialStore;
import org.glassfish.jersey.examples.oauth2.googleclient.Task;
import org.glassfish.jersey.examples.oauth2.googleclient.TaskList;
import org.glassfish.jersey.examples.oauth2.googleclient.TaskRoot;
import org.glassfish.jersey.jackson.JacksonFeature;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="tasks")
public class TaskResource {
    private static final String GOOGLE_TASKS_BASE_URI = "https://www.googleapis.com/tasks/v1/";
    @Context
    private UriInfo uriInfo;

    @GET
    public Response getTasks() {
        TokenResult tokenResult = CredentialStore.getTokenResult();
        if (tokenResult == null) {
            OAuth2CodeGrantFlow flow;
            String redirectURI = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path("oauth2/authorize").build(new Object[0]).toString();
            CredentialStore.cachedFlow = flow = OAuth2ClientSupport.googleFlowBuilder((ClientIdentifier)CredentialStore.getClientId(), (String)redirectURI, (String)"https://www.googleapis.com/auth/tasks.readonly").prompt(OAuth2FlowGoogleBuilder.Prompt.CONSENT).build();
            String uri = flow.start();
            return Response.seeOther((URI)UriBuilder.fromUri((String)uri).build(new Object[0])).build();
        }
        Client client = CredentialStore.cachedFlow.getAuthorizedClient();
        String message = "These tasks were queried using a Jersey client and access token received from the authorization flow:<br/>\n";
        return Response.ok((Object)(message + TaskResource.getTasksAsString((Client)client))).type(MediaType.TEXT_HTML_TYPE).build();
    }

    private static String getTasksAsString(Client client) {
        client.register(JacksonFeature.class);
        WebTarget baseTarget = client.target("https://www.googleapis.com/tasks/v1/");
        Response response = baseTarget.path("users/@me/lists").request().get();
        StringBuilder sb = new StringBuilder();
        TaskRoot taskRoot = (TaskRoot)response.readEntity(TaskRoot.class);
        for (TaskList taskList : taskRoot.getItems()) {
            sb.append("<b>" + taskList.getTitle() + "</b><br/>");
            WebTarget listTarget = baseTarget.path("lists/{tasklist}/tasks").resolveTemplate("tasklist", (Object)taskList.getId());
            TaskList fullTaskList = (TaskList)listTarget.request().get(TaskList.class);
            for (Task task : fullTaskList.getTasks()) {
                sb.append("   - ").append(task.getTitle()).append("<br/>");
            }
            sb.append("<br/>");
        }
        return sb.toString();
    }
}

