/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.opentracing;

import com.uber.jaeger.Configuration;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.opentracing.TracedResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.opentracing.OpenTracingFeature;
import org.glassfish.jersey.opentracing.OpenTracingUtils;
import org.glassfish.jersey.server.ResourceConfig;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/opentracing");

    public static void main(String[] args) {
        try {
            System.out.println("\"Hello World\" Jersey OpenTracing Example App");
            App.prepare();
            ResourceConfig resourceConfig = new ResourceConfig(new Class[]{TracedResource.class, OpenTracingFeature.class, ReqFilterA.class, ReqFilterB.class, RespFilterA.class, RespFilterB.class});
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)resourceConfig, (boolean)false);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HttpServer)server).shutdownNow()));
            server.start();
            System.out.println(String.format("Application started.\nTry out %s/application.wadl\nStop the application using CTRL+C", BASE_URI));
            Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(OpenTracingFeature.class)).build();
            client.target(BASE_URI).path("resource/managedClient").request().accept(new String[]{"text/plain", "application/json", "*/*"}).header("foo", (Object)"bar").header("foo", (Object)"baz").header("Hello", (Object)"World").get();
            Thread.currentThread().join();
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void prepare() {
        GlobalTracer.register((Tracer)new Configuration("OpenTracingTemporaryTest", new Configuration.SamplerConfiguration("const", (Number)1), new Configuration.ReporterConfiguration(Boolean.valueOf(true), "localhost", Integer.valueOf(5775), Integer.valueOf(1000), Integer.valueOf(10000))).getTracer());
    }

    static class RespFilterB
    implements ContainerResponseFilter {
        RespFilterB() {
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            Span span = OpenTracingUtils.getRequestSpan((ContainerRequestContext)requestContext).orElse(GlobalTracer.get().buildSpan("ad-hoc-span-respB").start());
            span.log("RespFilterB.filter() invoked");
        }
    }

    static class RespFilterA
    implements ContainerResponseFilter {
        RespFilterA() {
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            Span span = OpenTracingUtils.getRequestSpan((ContainerRequestContext)requestContext).orElse(GlobalTracer.get().buildSpan("ad-hoc-span-respA").start());
            span.log("RespFilterA.filter() invoked");
        }
    }

    static class ReqFilterB
    implements ContainerRequestFilter {
        ReqFilterB() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            Span span = OpenTracingUtils.getRequestSpan((ContainerRequestContext)requestContext).orElse(GlobalTracer.get().buildSpan("ad-hoc-span-reqB").start());
            span.log("ReqFilterB.filter() invoked");
        }
    }

    static class ReqFilterA
    implements ContainerRequestFilter {
        ReqFilterA() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            Span span = OpenTracingUtils.getRequestSpan((ContainerRequestContext)requestContext).orElse(GlobalTracer.get().buildSpan("ad-hoc-span-reqA").start());
            span.log("ReqFilterA.filter() invoked");
        }
    }
}

