/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.osgi.helloworld;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class WebAppContextListener
implements BundleActivator,
ServletContextListener {
    static EventAdmin ea;
    BundleContext bc;
    ServiceReference eaRef;

    static synchronized EventAdmin getEa() {
        return ea;
    }

    static synchronized void setEa(EventAdmin ea) {
        WebAppContextListener.ea = ea;
    }

    public void contextInitialized(ServletContextEvent sce) {
        if (WebAppContextListener.getEa() != null) {
            final String contextPath = sce.getServletContext().getContextPath();
            WebAppContextListener.getEa().sendEvent(new Event("jersey/test/DEPLOYED", (Map)new HashMap<String, String>(){
                {
                    this.put("context-path", contextPath);
                }
            }));
        }
    }

    public void contextDestroyed(final ServletContextEvent sce) {
        if (WebAppContextListener.getEa() != null) {
            WebAppContextListener.getEa().sendEvent(new Event("jersey/test/UNDEPLOYED", (Map)new HashMap<String, String>(){
                {
                    this.put("context-path", sce.getServletContext().getContextPath());
                }
            }));
        }
    }

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.eaRef = this.bc.getServiceReference(EventAdmin.class.getName());
        if (this.eaRef != null) {
            WebAppContextListener.setEa((EventAdmin)this.bc.getService(this.eaRef));
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.eaRef != null) {
            WebAppContextListener.setEa(null);
            this.bc.ungetService(this.eaRef);
        }
    }
}

