/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.osgihttpservice;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.glassfish.jersey.examples.osgihttpservice.JerseyApplication;
import org.glassfish.jersey.servlet.ServletContainer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private BundleContext bc;
    private ServiceTracker tracker;
    private HttpService httpService = null;
    private static final Logger logger = Logger.getLogger(Activator.class.getName());

    public synchronized void start(BundleContext bundleContext) throws Exception {
        this.bc = bundleContext;
        logger.info("STARTING HTTP SERVICE BUNDLE");
        this.tracker = new ServiceTracker(this.bc, HttpService.class.getName(), null){

            public Object addingService(ServiceReference serviceRef) {
                Activator.this.httpService = (HttpService)super.addingService(serviceRef);
                Activator.this.registerServlets();
                return Activator.this.httpService;
            }

            public void removedService(ServiceReference ref, Object service) {
                if (Activator.this.httpService == service) {
                    Activator.this.unregisterServlets();
                    Activator.this.httpService = null;
                }
                super.removedService(ref, service);
            }
        };
        this.tracker.open();
        logger.info("HTTP SERVICE BUNDLE STARTED");
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        this.tracker.close();
    }

    private void registerServlets() {
        try {
            this.rawRegisterServlets();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (ServletException se) {
            throw new RuntimeException(se);
        }
        catch (NamespaceException se) {
            throw new RuntimeException(se);
        }
    }

    private void rawRegisterServlets() throws ServletException, NamespaceException, InterruptedException {
        logger.info("JERSEY BUNDLE: REGISTERING SERVLETS");
        logger.info("JERSEY BUNDLE: HTTP SERVICE = " + this.httpService.toString());
        this.httpService.registerServlet("/jersey-http-service", (Servlet)new ServletContainer(), this.getJerseyServletParams(), null);
        this.sendAdminEvent();
        logger.info("JERSEY BUNDLE: SERVLETS REGISTERED");
    }

    private void sendAdminEvent() {
        ServiceReference eaRef = this.bc.getServiceReference(EventAdmin.class.getName());
        if (eaRef != null) {
            EventAdmin ea = (EventAdmin)this.bc.getService(eaRef);
            ea.sendEvent(new Event("jersey/test/DEPLOYED", (Map)new HashMap<String, String>(){
                {
                    this.put("context-path", "/");
                }
            }));
            this.bc.ungetService(eaRef);
        }
    }

    private void unregisterServlets() {
        if (this.httpService != null) {
            logger.info("JERSEY BUNDLE: UNREGISTERING SERVLETS");
            this.httpService.unregister("/jersey-http-service");
            logger.info("JERSEY BUNDLE: SERVLETS UNREGISTERED");
        }
    }

    private Dictionary<String, String> getJerseyServletParams() {
        Hashtable<String, String> jerseyServletParams = new Hashtable<String, String>();
        ((Dictionary)jerseyServletParams).put("javax.ws.rs.Application", JerseyApplication.class.getName());
        return jerseyServletParams;
    }
}

