/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.reload;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.reload.ArrivalsResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/flights/");
    public static final String ROOT_PATH = "arrivals";
    public static final String CONFIG_FILENAME = "resources";
    public static final long REFRESH_PERIOD_MS = 2000L;
    static Container container;

    public static void main(String[] args) {
        try {
            System.out.println("Resource Config Reload Jersey Example App");
            ResourceConfig resourceConfig = new ResourceConfig(new Class[]{ArrivalsResource.class});
            resourceConfig.registerInstances(new Object[]{new ContainerLifecycleListener(){

                public void onStartup(Container container) {
                    App.container = container;
                    Timer t = new Timer(true);
                    t.scheduleAtFixedRate((TimerTask)new FileCheckTask(0L), 0L, 2000L);
                }

                public void onReload(Container container) {
                    System.out.println("Application has been reloaded!");
                }

                public void onShutdown(Container container) {
                }
            }});
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)resourceConfig);
            System.out.println(String.format("Application started.\nTry out %s%s\nHit enter to stop it...", BASE_URI, ROOT_PATH));
            System.in.read();
            server.shutdownNow();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static class FileCheckTask
    extends TimerTask {
        long lastModified;

        FileCheckTask(long lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public void run() {
            File configFile = new File(App.CONFIG_FILENAME);
            long actualLastModified = configFile.lastModified();
            if (this.lastModified < actualLastModified) {
                this.lastModified = actualLastModified;
                this.reloadApp(configFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void reloadApp(File configFile) {
            System.out.println("Reloading resource classes:");
            ResourceConfig rc = new ResourceConfig();
            try (BufferedReader r = new BufferedReader(new FileReader(configFile));){
                while (r.ready()) {
                    String className = r.readLine();
                    if (!className.startsWith("#")) {
                        try {
                            rc.registerClasses(new Class[]{Class.forName(className)});
                            System.out.printf(" + loaded class %s.\n", className);
                            continue;
                        }
                        catch (ClassNotFoundException ex) {
                            System.out.printf(" ! class %s not found.\n", className);
                            continue;
                        }
                    }
                    System.out.printf(" - ignored class %s\n", className.substring(1));
                }
            }
            catch (Exception ex) {
                Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
            }
            container.reload(rc);
        }
    }
}

