/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.reload.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.glassfish.jersey.examples.reload.compiler.AppClassLoader;
import org.glassfish.jersey.examples.reload.compiler.ClassFile;
import org.glassfish.jersey.examples.reload.compiler.FileManager;
import org.glassfish.jersey.examples.reload.compiler.JavaFile;

public class Compiler {
    private static JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
    public static String classpath;

    public static Class<?> compile(String className, SimpleJavaFileObject sourceCode) throws Exception {
        ClassFile classFile = new ClassFile(className);
        List<SimpleJavaFileObject> compilationUnits = Arrays.asList(sourceCode);
        AppClassLoader cl = new AppClassLoader(Thread.currentThread().getContextClassLoader());
        FileManager fileManager = new FileManager(javac.getStandardFileManager(null, null, null), Arrays.asList(classFile), cl);
        JavaCompiler.CompilationTask task = javac.getTask(null, fileManager, null, Compiler.getClOptions(), null, compilationUnits);
        task.call();
        return cl.loadClass(className);
    }

    public static void compile(AppClassLoader appClassLoader, List<JavaFile> javaFiles) throws Exception {
        LinkedList<ClassFile> classes = new LinkedList<ClassFile>();
        for (JavaFile javaFile : javaFiles) {
            classes.add(new ClassFile(javaFile.getClassName()));
        }
        List<JavaFile> compilationUnits = javaFiles;
        FileManager fileManager = new FileManager(javac.getStandardFileManager(null, null, null), classes, appClassLoader);
        JavaCompiler.CompilationTask task = javac.getTask(null, fileManager, null, Compiler.getClOptions(), null, compilationUnits);
        task.call();
    }

    private static List<String> getClOptions() {
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.addAll(Arrays.asList("-classpath", classpath + File.pathSeparator + "target/classes"));
        return optionList;
    }
}

