/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.reload.compiler;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.glassfish.jersey.examples.reload.compiler.AppClassLoader;
import org.glassfish.jersey.examples.reload.compiler.ClassFile;

public class FileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Map<String, ClassFile> classFiles = new HashMap<String, ClassFile>();
    private final AppClassLoader cl;

    protected FileManager(JavaFileManager fileManager, List<ClassFile> classFiles, AppClassLoader cl) {
        super(fileManager);
        this.cl = cl;
        for (ClassFile classFile : classFiles) {
            this.classFiles.put(classFile.getClassName(), classFile);
        }
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        ClassFile classFile = this.classFiles.get(className);
        if (classFile != null) {
            this.cl.setCode(classFile);
        }
        return classFile;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.cl;
    }
}

